<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Blade;
use App\View\Components\BBEditor;
use App\Services\PluginManager;
use App\Helpers\HtmlSanitizer;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(PluginManager::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        \URL::forceScheme("https");
        Paginator::defaultView('vendor.pagination.edge');
        Blade::component('bb-editor', BBEditor::class);

        Blade::directive('sanitize', function ($expression) {
            return "<?php echo \App\Helpers\HtmlSanitizer::sanitize($expression); ?>";
        });

        $pluginManager = app(PluginManager::class);
        $pluginManager->loadAllPlugins();
    }
}
